define(['angular', 'app'], function (angular, app) {
    'use strict';
    app.service('MoodFeedbackService', function(MoodFeedbackConstants) {
        var MoodFeedbackService = {},
            localStorageKey = 'fitheart-mood-feedback',
            dashboard;
        
        MoodFeedbackService.getLowMessage = function() {
            return {
                icon: MoodFeedbackConstants['low'].icon,
                text:  MoodFeedbackConstants['low'].text[0]
            };          
        };

        MoodFeedbackService.getMidMessage = function() {
            return getNextMessage('mid');
        };

        MoodFeedbackService.getHighMessage = function() {
            return getNextMessage('high');
        };
        
        var getNextMessage = function(messageType) {
            var nextIndex = getNextIndex(messageType);
            return {
                icon: MoodFeedbackConstants[messageType].icon,
                text:  MoodFeedbackConstants[messageType].text[nextIndex]
            };            
        };

        var getNextIndex = function(messageType) {
            var textLength  = MoodFeedbackConstants[messageType].text.length,
                currentTextIndex  = Number(dashboard[messageType]),
                nextIndex = 0,
                needUpdateLocalStore = false;

                      
            if(currentTextIndex < textLength) {
                needUpdateLocalStore = true;
                nextIndex = currentTextIndex++;
            } else {
                nextIndex = getRandom(textLength);
            }
            
            if(needUpdateLocalStore) {
                dashboard[messageType]  = currentTextIndex;
                saveLocalStorage(dashboard);
            }
            
            return nextIndex;
        };
        
        var getRandom = function(size) {
            return Math.floor((Math.random() * size));
        }
        
        var initDashboard = function() {
            return {                
                'mid' : 0,
                'high' : 0
            };                
        };

        MoodFeedbackService.fetchLocalStorage = function() {
            return JSON.parse(localStorage.getItem(localStorageKey));            
        };
        
        var saveLocalStorage = function(object) {
            localStorage.setItem(localStorageKey, JSON.stringify(object));
        };

        (function init() {
            dashboard = MoodFeedbackService.fetchLocalStorage();
            if(!dashboard) {
                dashboard = initDashboard();
                saveLocalStorage(dashboard);
            }
        })();

        return MoodFeedbackService;
    });    
});